/*
OLED PIN Connection:
OLED    ESP32
3v3     3V3
gnd     gnd
AD      D15
CS      D2
Reset   D4
SCK     D18
SDA     D23

For full 128*128 display change in the  
TFT_ILI9163_settings.h file offsets.
See comment by Bera
--------------------------
SDCard Connection
SDCard  ESP32
VCC     3V3
gd      gnd
SS/CS   Select your Pin
        (D22)
Clk/Sck D18
MISO    D19
MOSI    D23
*/

#include "FS.h"
#include "SD.h"
#include "SPI.h"
#include <Adafruit_GFX.h>
#include <TFT_ILI9163C.h>

#define SD_CS_PIN 22   //select the CS pin
File myFile;

char fl[5];


#define BUFFPIXEL 20
int p;
boolean SDInited = true;

TFT_ILI9163C tft = TFT_ILI9163C(2,15,4);

void setup(void) {
  Serial.begin(115200);

  tft.begin();
  tft.setRotation(1);

  if (!SD.begin(SD_CS_PIN)) {
    tft.setCursor(0,0);
    tft.print("sd failed!");
    SDInited = false;
    esp_restart();   //Restart again if the SDCard fails to load first time
  }
  Serial.println("OK!");
}

void loop() {
long dl=5000;
for(p=1;p<=23;p++){
  sprintf(fl, "/%d.bmp", p);
  Serial.println(fl);
  bmpDraw(fl,0,0); 
  delay(dl);
  tft.clearScreen();
  }
}



void bmpDraw(const char *filename, uint8_t x, uint16_t y) {
  if (SDInited){

    File     bmpFile;
    uint16_t bmpWidth, bmpHeight;   // W+H in pixels
    uint8_t  bmpDepth;              // Bit depth (currently must be 24)
    uint32_t bmpImageoffset;        // Start of image data in file
    uint32_t rowSize;               // Not always = bmpWidth; may have padding
    uint8_t  sdbufferLen = BUFFPIXEL * 3;
    uint8_t  sdbuffer[sdbufferLen]; // pixel buffer (R+G+B per pixel)
    uint8_t  buffidx = sdbufferLen; // Current position in sdbuffer
    boolean  goodBmp = false;       // Set to true on valid header parse
    boolean  flip    = true;        // BMP is stored bottom-to-top
    uint16_t w, h, row, col;
    uint8_t  r, g, b;
    uint32_t pos = 0;

    if((x >= tft.width()) || (y >= tft.height())) return;

    // Open requested file on SD card
    if ((bmpFile = SD.open(filename)) == NULL) {
      tft.setCursor(0,0);
      tft.print("file not found!");
      return;
    }

    // Parse BMP header
    if(read16(bmpFile) == 0x4D42) { // BMP signature
      read32(bmpFile);
      (void)read32(bmpFile); // Read & ignore creator bytes
      bmpImageoffset = read32(bmpFile); // Start of image data
      // Read DIB header
      read32(bmpFile);
      bmpWidth  = read32(bmpFile);
      bmpHeight = read32(bmpFile);
      if(read16(bmpFile) == 1) { // # planes -- must be '1'
        bmpDepth = read16(bmpFile); // bits per pixel
        if((bmpDepth == 24) && (read32(bmpFile) == 0)) { // 0 = uncompressed
          goodBmp = true; // Supported BMP format -- proceed!
          rowSize = (bmpWidth * 3 + 3) & ~3;// BMP rows are padded (if needed) to 4-byte boundary
          if (bmpHeight < 0) {
            bmpHeight = -bmpHeight;
            flip      = false;
          }
          // Crop area to be loaded
          w = bmpWidth;
          h = bmpHeight;
          if((x+w-1) >= tft.width())  w = tft.width()  - x;
          if((y+h-1) >= tft.height()) h = tft.height() - y;
          tft.startPushData(x, y, x+w-1, y+h-1);
          for (row=0; row<h; row++) { // For each scanline...
            if (flip){ // Bitmap is stored bottom-to-top order (normal BMP)
              pos = bmpImageoffset + (bmpHeight - 1 - row) * rowSize;
            } 
            else {     // Bitmap is stored top-to-bottom
              pos = bmpImageoffset + row * rowSize;
            }
            if (bmpFile.position() != pos) { // Need seek?
              bmpFile.seek(pos);
              buffidx = sdbufferLen; // Force buffer reload
            }
            for (col=0; col<w; col++) { // For each pixel...
              // Time to read more pixel data?
              if (buffidx >= sdbufferLen) { // Indeed
                bmpFile.read(sdbuffer, sdbufferLen);
                buffidx = 0; // Set index to beginning
              }
              // Convert pixel from BMP to TFT format, push to display
              b = sdbuffer[buffidx++];
              g = sdbuffer[buffidx++];
              r = sdbuffer[buffidx++];
              tft.pushData(tft.Color565(r,g,b));
            } // end pixel
          } // end scanline
          tft.endPushData();
        } // end goodBmp
      }
    }

    bmpFile.close();
    if(!goodBmp) {
      tft.setCursor(0,0);
      tft.print("file unrecognized!");
    }
  }
}


uint16_t read16(File &f) {
  uint16_t result;
  ((uint8_t *)&result)[0] = f.read(); // LSB
  ((uint8_t *)&result)[1] = f.read(); // MSB
  return result;
}

uint32_t read32(File &f) {
  uint32_t result;
  ((uint8_t *)&result)[0] = f.read(); // LSB
  ((uint8_t *)&result)[1] = f.read();
  ((uint8_t *)&result)[2] = f.read();
  ((uint8_t *)&result)[3] = f.read(); // MSB
  return result;
}

